/* 
 *  GetCallbackDestinationsRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.enums.DestinationType;
import java.util.List;

public class GetCallbackDestinationsRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(GetCallbackDestinationsRequest.class);

    public GetCallbackDestinationsRequest(String interactionID) {
        super(LOG, interactionID);
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        InteractionI interaction = getInteraction();

        List<DestinationType> types = interaction.getCallbackDestinationTypes();
        for (DestinationType type : types) {
            LOG.trace(methodName + " requesting type:" + type.name());
            interaction.getCallbackDestinations(type);
        }
        LOG.trace(methodName + "-");
        return null;
    }
}
